//Micro: ATmega328P 
 #ifndef F_CPU	1000000UL
 #define F_CPU	1000000UL
 #endif

 #include <util/delay.h>
 #include <avr/io.h>
 #include <avr/interrupt.h>

 #include "lcd.h"

 #define SET_HOUR  1
 #define SET_MINUTE 2

 //defined custom character:degree symbol
char chr0[8] = { 0x0C, 0x12, 0x12, 0x0C, 0x00, 0x00, 0x00,0x00 }; 

//Global variables
uint8_t hours, minutes, seconds;
float c ,f;

//Function declarations
uint16_t Adc_Result(uint8_t ch);
void Display_Temperature(void);

void Update_Time(void);
void Display_Time(void);
void Set_Time (void);

//Timer Counter 1 Compare Match A Interrupt Service Routine
ISR(TIMER1_COMPA_vect);

/*------------------------------------------*/ 
int main(void)

{	
	//Configure PORTB input
	DDRB = 0x00;
	// Activate pull-ups
	PORTB =0xff ;
			
	//1000000/8=12500
	ADCSRA |= _BV(ADEN)| _BV(ADPS1) | _BV(ADPS0);
	// Configure Timer 1 for CTC mode	
	TCCR1B |= (1 << WGM12); 
	//1000000/64=15625-1 -Set CTC compare value to 1 Hz at 1 MHz AVR clock 
	OCR1A = 15624; 
	// Start timer at F_CPU /64
	TCCR1B |= ((1 << CS10) | (1 << CS11)); 
	
	//Timer/Counter1, Output Compare A Match Interrupt Enable
	TIMSK1 = 1<<OCIE1A;
	
	//Set global interrupt enable
	sei();
	
	//Initialize LCD
	LCD_init();
	
	//LCD clear display
	LCD_Clear();
	
	//LCD go to line 1, position 7
	LCD_goto(1,7);
	
	//LCD print character: L
	LCD_Chr('L');
	_delay_ms(500);
	
	//LCD print character: C
	LCD_Chr('C');
	_delay_ms(500);
	
	//LCD print character: D
	LCD_Chr('D');
	
	_delay_ms(500);
	
	LCD_goto(2,3);
	
	//LCD print text: Library Test
	LCD_Text("Library Test");
	_delay_ms(1000);
		
	//LCD scroll the text(on lines 1 and 2) to left and
	//then to right without changing contents.
	uint8_t i;
	for (i=1;i<17;i++)
	{
		//scroll left
		LCD_Scroll_Left();
		_delay_ms(50);
	}
	
	for (i=1;i<17;i++)
	{
		//scroll right
		LCD_Scroll_Right();
		_delay_ms(50);
	}
	_delay_ms(2000);
	
	//LCD clear only line 2
	LCD_Clr_Line(2);
	
	LCD_goto(2,2);
	LCD_Text("Sample Program");
	_delay_ms(2000);
	//LCD clear the display(both lines)
	LCD_Clear();
/*------------------------------------------*/	
	while(1)
    {
		//ADC result at PINC 0
		//c for Celsius
		c =Adc_Result(0);
		c=c/2;
		
		//f for Fahrenheit
		//Convert Celsius to Fahrenheit
		f=c*1.8;
		f=f+32;
		
		Display_Temperature();
		
		Update_Time();
		Display_Time();
		Set_Time();		
				
	}		
}
 
/****************************************************/

uint16_t Adc_Result(uint8_t ch)
{
	ADMUX=ch;
	// Start single conversion
	// Write '1' to ADSC
	ADCSRA |= _BV(ADSC);
	
	// Wait for conversion to complete
	// ADSC becomes '0' again
	// till then, run loop continuously
	while(ADCSRA & _BV(ADSC));
	
	return (ADCW);
}
/*------------------------------------------*/
void Update_Time(void)
{
	if(seconds == 60)
	{
		seconds = 0;
		minutes++;
	}
	if(minutes == 60)
	{
		minutes = 0;
		hours++;
	}
	if(hours > 23)
		hours = 0;
}
/*------------------------------------------*/
void Display_Time()
{
	LCD_goto(1,2);
	LCD_Text("Time: ");

	LCD_Int(hours/10);
	LCD_Int(hours%10);
	LCD_Text(":");
	
	LCD_Int(minutes/10);
	LCD_Int(minutes%10);
	LCD_Text(":");
	
	LCD_Int(seconds/10);
	LCD_Int(seconds%10);

}
/*------------------------------------------*/
void Set_Time (void)
	{
		//If PINB1=0
		if(bit_is_clear(PINB,SET_HOUR))
			{
				hours++;
				if(hours > 23)
					hours = 0;
					_delay_ms(200);
			}

		//If PINB2=0
		if(bit_is_clear(PINB,SET_MINUTE))
			{
				minutes++;
				if(minutes > 59)
					minutes = 0;
					_delay_ms(200);
			}

	}
/*------------------------------------------*/
void Display_Temperature(void)
{
	//LCD generate custom character 0:degree symbol
	LCD_Custom_chr(0,chr0);
	
	LCD_goto(2,1);
	//Display Celsius degree with 1 decimal digit
	LCD_Float(c,1);	// Here 1 means 1 decimal digit
	
	//Display custom character 0: degree
	LCD_Chr(0);
	//Display character: C
	LCD_Chr('C');
	
	LCD_goto(2,10);
	//Display Fahrenheit degrees with 1 decimal digit
	LCD_Float(f,1);	// Here 1 means 1 decimal digit
	
	//Display custom character 0: degree
	LCD_Chr(0);
	//Display character: F
	LCD_Chr('F');
}
/*------------------------------------------*/
/*Timer Counter 1 Compare Match A Interrupt Service Routine*/
ISR(TIMER1_COMPA_vect)
{
	seconds++;			
}
/********************************************/
//End of Program
